/*
 * Decompiled with CFR 0.152.
 */
package levelup2.skills.combat;

import levelup2.config.LevelUpConfig;
import levelup2.skills.BaseSkill;
import levelup2.skills.SkillRegistry;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SwordDamageBonus
extends BaseSkill {
    @Override
    public String getSkillName() {
        return "levelup:sworddamage";
    }

    @Override
    public byte getSkillType() {
        return 2;
    }

    @Override
    public boolean hasSubscription() {
        return true;
    }

    @Override
    public ItemStack getRepresentativeStack() {
        return new ItemStack(Items.field_151010_B);
    }

    @SubscribeEvent
    public void onHurting(LivingHurtEvent evt) {
        if (!this.isActive()) {
            return;
        }
        DamageSource source = evt.getSource();
        float amount = evt.getAmount();
        if (source.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)source.func_76346_g();
            int skill = SkillRegistry.getSkillLevel(player, this.getSkillName());
            if (skill > 0 && !(source instanceof EntityDamageSourceIndirect)) {
                if (!player.func_184614_ca().func_190926_b()) {
                    amount *= 1.0f + (float)skill / 20.0f;
                    if (LevelUpConfig.damageScaling && !(evt.getEntityLiving() instanceof EntityPlayer) && evt.getEntityLiving().func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e() > 20.0) {
                        double health = evt.getEntityLiving().func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e();
                        float skillOutput = (float)skill / 40.0f;
                        amount = (float)((double)amount + Math.min(health * (double)skillOutput, health * 0.375));
                    }
                    evt.setAmount(amount);
                }
            } else {
                skill = SkillRegistry.getSkillLevel(player, "levelup:arrowspeed");
                String src = source.func_76355_l();
                if (skill > 0 && src.equals("arrow")) {
                    amount *= 1.0f + (float)skill / 20.0f;
                    if (LevelUpConfig.damageScaling && !(evt.getEntityLiving() instanceof EntityPlayer) && evt.getEntityLiving().func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e() > 20.0) {
                        double health = evt.getEntityLiving().func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e();
                        float skillOutput = (float)skill / 40.0f;
                        amount = (float)((double)amount + Math.min(health * (double)skillOutput, health * 0.375));
                        evt.setAmount(amount);
                    }
                }
            }
        }
    }
}

